# -*- coding: UTF-8 -*-
#   TimeVault - automated file backup and restore
#   Copyright (C) 2007 A. Bashi <sourcecontact@gmail.com>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import gobject

import dbus
import dbus.service
import dbus.glib

class DBusClient:
	def __init__(self):
		self.ConnectToServer()
	
	def ConnectToServer(self):
		self.interface = None
		try:
			bus = dbus.SystemBus()
			bus.get_object("net.launchpad.timevault","/net/launchpad/timevault")
			service = bus.get_object("net.launchpad.timevault", "/net/launchpad/timevault")
			self.interface = dbus.Interface(service, "net.launchpad.timevault")
			
			self.interface.connect_to_signal('OnNotifyConfigurationChange', self.OnNotifyConfigurationChange)
			self.interface.connect_to_signal('OnINotify', self.OnINotify)
			self.interface.connect_to_signal('OnEcho', self.OnEcho)
			self.interface.connect_to_signal('OnPopup', self.OnPopup)
			self.interface.connect_to_signal('OnState', self.OnState)
			self.interface.connect_to_signal('OnServerShutdown', self.OnServerShutdown)
			self.interface.connect_to_signal('OnScheduleSnap', self.OnScheduleSnap)
			self.interface.connect_to_signal('OnSnap', self.OnSnap)
			
			self.connected = True
		except:
			self.connected = False
		return self.connected
		
	def Start(self):
		self.mainloop = gobject.MainLoop()
		self.mainloop.run()
		
	def OnServerShutdown(self):
		self.connected = False
	
	def OnScheduleSnap(self, thisTime, thisNum):
		pass

	def OnSnap(self, tm, num, firstN):
		pass

	def OnNotifyConfigurationChange(self):
		print("Client:OnNotifyConfigurationChange")
		pass
		
	def OnINotify(self, path, etype):
		pass
		
	def OnEcho(self, msg):
		pass
		
	def OnPopup(self, summary, markup, duration):
		pass

	def OnState(self, text):
		pass

if __name__ == "__main__":
	def Emitter(client):
		global emission
		emission += 1
		
		client.interface.Echo("Echo %d" % emission)
		gobject.timeout_add(1000, Emitter, client)
	
	emission = 0
	client = DBusClient()
	Emitter(client)
	
	client.Start()

