﻿
-- 
-- Estrutura da tabela `caixa`
-- 

CREATE TABLE `caixa` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `descricao` varchar(80) NOT NULL,
  `entrada` varchar(80) NOT NULL,
  `saida` varchar(80) NOT NULL,
  `data` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8768 ;


-- 
-- Estrutura da tabela `clientes`
-- 

CREATE TABLE `clientes` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `nome` varchar(80) NOT NULL,
  `endereco` varchar(80) NOT NULL,
  `referencia` varchar(80) NOT NULL,
  `telefone` varchar(80) NOT NULL,
  `celular` varchar(80) NOT NULL,
  `rg` varchar(80) NOT NULL,
  `cpf` varchar(80) NOT NULL,
  `obs` varchar(80) NOT NULL,
  `plano` varchar(80) NOT NULL,
  `UserName` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `username` (`UserName`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;


-- 
-- Estrutura da tabela `contas_pagar`
-- 

CREATE TABLE `contas_pagar` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `local_a_pagar` varchar(80) NOT NULL,
  `tipo_documento` varchar(80) NOT NULL,
  `n_documento` varchar(80) NOT NULL,
  `n_parcela` varchar(80) NOT NULL,
  `valor` varchar(80) NOT NULL,
  `vencimento` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;


-- 
-- Estrutura da tabela `contas_pagas`
-- 

CREATE TABLE `contas_pagas` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `local_a_pagar` varchar(80) NOT NULL,
  `n_parcela` varchar(80) NOT NULL,
  `tipo_documento` varchar(80) NOT NULL,
  `n_documento` varchar(80) NOT NULL,
  `valor` varchar(80) NOT NULL,
  `vencimento` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;


-- 
-- Estrutura da tabela `contas_receber`
-- 

CREATE TABLE `contas_receber` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `cliente` varchar(80) NOT NULL,
  `tipo_documento` varchar(80) NOT NULL,
  `n_documento` varchar(80) NOT NULL,
  `n_parcela` varchar(80) NOT NULL,
  `valor` varchar(80) NOT NULL,
  `obs` varchar(80) NOT NULL,
  `emissao` varchar(80) NOT NULL,
  `vencimento` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8768 ;


-- 
-- Estrutura da tabela `contas_recebidas`
-- 

CREATE TABLE `contas_recebidas` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `cliente` varchar(80) NOT NULL,
  `tipo_documento` varchar(80) NOT NULL,
  `n_documento` varchar(80) NOT NULL,
  `n_parcela` varchar(80) NOT NULL,
  `valor` varchar(80) NOT NULL,
  `recebido` varchar(80) NOT NULL,
  `vencimento` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=19 ;


-- 
-- Estrutura da tabela `funcionario`
-- 

CREATE TABLE `funcionario` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `nome` varchar(80) NOT NULL,
  `endereco` varchar(80) NOT NULL,
  `telefone` varchar(80) NOT NULL,
  `rg` varchar(80) NOT NULL,
  `cpf` varchar(80) NOT NULL,
  `cargo` varchar(80) NOT NULL,
  `salario` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;



-- 
-- Estrutura da tabela `planos`
-- 

CREATE TABLE `planos` (
  `id` int(10) NOT NULL auto_increment,
  `plano` varchar(128) NOT NULL default '',
  `valor` varchar(64) NOT NULL,
  `velocidade` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

-- 
-- Extraindo dados da tabela `planos`
-- 

UPDATE `planos` SET `id` = 1, `plano` = 'N128', `valor` = '54,90', `velocidade` = '128' WHERE  `planos`.`id` = 1;
UPDATE `planos` SET `id` = 2, `plano` = 'N150', `valor` = '54,90', `velocidade` = '150' WHERE  `planos`.`id` = 2;
UPDATE `planos` SET `id` = 3, `plano` = 'N200', `valor` = '94,90', `velocidade` = '200' WHERE  `planos`.`id` = 3;
UPDATE `planos` SET `id` = 4, `plano` = 'N300', `valor` = '144,90', `velocidade` = '300' WHERE  `planos`.`id` = 4;
UPDATE `planos` SET `id` = 5, `plano` = 'T128', `valor` = '74,90', `velocidade` = '128' WHERE  `planos`.`id` = 5;
UPDATE `planos` SET `id` = 6, `plano` = 'T200', `valor` = '124,90', `velocidade` = '200' WHERE  `planos`.`id` = 6;
UPDATE `planos` SET `id` = 7, `plano` = 'T300', `valor` = '164,90', `velocidade` = '300' WHERE  `planos`.`id` = 7;
UPDATE `planos` SET `id` = 8, `plano` = 'T400', `valor` = '204,90', `velocidade` = '400' WHERE  `planos`.`id` = 8;
UPDATE `planos` SET `id` = 9, `plano` = 'bloqueado', `valor` = '0', `velocidade` = '0' WHERE  `planos`.`id` = 9;

-- --------------------------------------------------------

-- 
-- Estrutura da tabela `radacct`
-- 

CREATE TABLE `radacct` (
  `RadAcctId` bigint(21) NOT NULL auto_increment,
  `AcctSessionId` varchar(32) NOT NULL default '',
  `AcctUniqueId` varchar(32) NOT NULL default '',
  `UserName` varchar(64) NOT NULL default '',
  `Realm` varchar(64) default '',
  `NASIPAddress` varchar(15) NOT NULL default '',
  `NASPortId` varchar(15) default NULL,
  `NASPortType` varchar(32) default NULL,
  `AcctStartTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `AcctStopTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `AcctSessionTime` int(12) default NULL,
  `AcctAuthentic` varchar(32) default NULL,
  `ConnectInfo_start` varchar(50) default NULL,
  `ConnectInfo_stop` varchar(50) default NULL,
  `AcctInputOctets` bigint(12) default NULL,
  `AcctOutputOctets` bigint(12) default NULL,
  `CalledStationId` varchar(50) NOT NULL default '',
  `CallingStationId` varchar(50) NOT NULL default '',
  `AcctTerminateCause` varchar(32) NOT NULL default '',
  `ServiceType` varchar(32) default NULL,
  `FramedProtocol` varchar(32) default NULL,
  `FramedIPAddress` varchar(15) NOT NULL default '',
  `AcctStartDelay` int(12) default NULL,
  `AcctStopDelay` int(12) default NULL,
  PRIMARY KEY  (`RadAcctId`),
  KEY `UserName` (`UserName`),
  KEY `FramedIPAddress` (`FramedIPAddress`),
  KEY `AcctSessionId` (`AcctSessionId`),
  KEY `AcctUniqueId` (`AcctUniqueId`),
  KEY `AcctStartTime` (`AcctStartTime`),
  KEY `AcctStopTime` (`AcctStopTime`),
  KEY `NASIPAddress` (`NASIPAddress`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=358 ;

-- 
-- Estrutura da tabela `radcheck`
-- 

CREATE TABLE `radcheck` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `UserName` varchar(64) NOT NULL default '',
  `Attribute` varchar(32) NOT NULL default '',
  `op` char(2) NOT NULL default '==',
  `Value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `UserName` (`UserName`(32))
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2494 ;


-- 
-- Estrutura da tabela `radgroupcheck`
-- 

CREATE TABLE `radgroupcheck` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `GroupName` varchar(64) NOT NULL default '',
  `Attribute` varchar(32) NOT NULL default '',
  `op` char(2) NOT NULL default '==',
  `Value` varchar(253) NOT NULL default '',
  `Units` varchar(100) default '',
  PRIMARY KEY  (`id`),
  KEY `GroupName` (`GroupName`(32))
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;


-- 
-- Estrutura da tabela `radgroupreply`
-- 

CREATE TABLE `radgroupreply` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `GroupName` varchar(64) NOT NULL default '',
  `Attribute` varchar(32) NOT NULL default '',
  `op` char(2) NOT NULL default '==',
  `Value` varchar(253) NOT NULL default '',
  `Units` varchar(100) default '',
  PRIMARY KEY  (`id`),
  KEY `GroupName` (`GroupName`(32))
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=33 ;


-- 
-- Estrutura da tabela `radippool`
-- 

CREATE TABLE `radippool` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `pool_name` varchar(30) NOT NULL,
  `FramedIPAddress` varchar(15) NOT NULL default '',
  `NASIPAddress` varchar(15) NOT NULL default '',
  `CalledStationId` varchar(30) NOT NULL,
  `CallingStationID` varchar(30) NOT NULL,
  `expiry_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `username` varchar(64) NOT NULL default '',
  `pool_key` varchar(30) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- 
-- Estrutura da tabela `radpostauth`
-- 

CREATE TABLE `radpostauth` (
  `id` int(11) NOT NULL auto_increment,
  `user` varchar(64) NOT NULL default '',
  `pass` varchar(64) NOT NULL default '',
  `reply` varchar(32) NOT NULL default '',
  `date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=146 ;


-- 
-- Estrutura da tabela `radreply`
-- 

CREATE TABLE `radreply` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `UserName` varchar(64) NOT NULL default '',
  `Attribute` varchar(32) NOT NULL default '',
  `op` char(2) NOT NULL default '=',
  `Value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `UserName` (`UserName`(32))
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;


-- 
-- Estrutura da tabela `salario`
-- 

CREATE TABLE `salario` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `funcionario` varchar(80) NOT NULL,
  `tipo_pagamento` varchar(80) NOT NULL,
  `data` varchar(80) NOT NULL,
  `valor` varchar(80) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=22 ;


-- 
-- Estrutura da tabela `saldo`
-- 

CREATE TABLE `saldo` (
  `id` int(10) NOT NULL auto_increment,
  `saldo` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;


-- 
-- Estrutura da tabela `tipo_documento`
-- 

CREATE TABLE `tipo_documento` (
  `id` int(10) NOT NULL auto_increment,
  `tipo` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

-- 
-- Extraindo dados da tabela `tipo_documento`
-- 

UPDATE `tipo_documento` SET `id` = 1, `tipo` = 'CarnÃª' WHERE  `tipo_documento`.`id` = 1;
UPDATE `tipo_documento` SET `id` = 2, `tipo` = 'Boleto' WHERE  `tipo_documento`.`id` = 2;
UPDATE `tipo_documento` SET `id` = 3, `tipo` = 'Cheque' WHERE  `tipo_documento`.`id` = 3;

-- --------------------------------------------------------

-- 
-- Estrutura da tabela `usergroup`
-- 

CREATE TABLE `usergroup` (
  `UserName` varchar(64) NOT NULL default '',
  `GroupName` varchar(64) NOT NULL default '',
  `priority` int(11) NOT NULL default '1',
  KEY `UserName` (`UserName`(32))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Extraindo dados da tabela `usergroup`
-- 


-- --------------------------------------------------------

-- 
-- Estrutura da tabela `userinfo`
-- 

CREATE TABLE `userinfo` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(30) default NULL,
  `firstname` varchar(200) default NULL,
  `lastname` varchar(200) default NULL,
  `email` varchar(200) default NULL,
  `department` varchar(200) default NULL,
  `company` varchar(200) default NULL,
  `workphone` varchar(200) default NULL,
  `homephone` varchar(200) default NULL,
  `mobilephone` varchar(200) default NULL,
  `notes` varchar(200) default NULL,
  `creationdate` datetime default '0000-00-00 00:00:00',
  `creationby` varchar(128) default NULL,
  `updatedate` datetime default '0000-00-00 00:00:00',
  `updateby` varchar(128) default NULL,
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- 
-- Estrutura da tabela `users`
-- 

CREATE TABLE `users` (
  `id` int(3) NOT NULL auto_increment,
  `loginname` varchar(255) default '0',
  `password` varchar(255) default '0',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=15 ;

-- 
-- Extraindo dados da tabela `users`
-- 

UPDATE `users` SET `id` = 1, `loginname` = 'admin', `password` = 'admin' WHERE  `users`.`id` = 1;
