/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jpjust;

public class ComplexNum {
    private double a;
    private double b;

    public ComplexNum() {
        this.a = 0.0;
        this.b = 0.0;
    }

    public ComplexNum(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public ComplexNum(ComplexNum n) {
        this.a = n.getA();
        this.b = n.getB();
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getA() {
        return this.a;
    }

    public void setB(double b) {
        this.b = b;
    }

    public double getB() {
        return this.b;
    }

    public double modulo() {
        return Math.sqrt(Math.pow(this.getA(), 2.0) + Math.pow(this.getB(), 2.0));
    }

    public ComplexNum conjugado() {
        ComplexNum r = new ComplexNum(this);
        r.setB(this.getB() * -1.0);
        return r;
    }

    public ComplexNum soma(ComplexNum n) {
        ComplexNum r = new ComplexNum(this);
        r.setA(this.getA() + n.getA());
        r.setB(this.getB() + n.getB());
        return r;
    }

    public ComplexNum subtracao(ComplexNum n) {
        ComplexNum r = new ComplexNum(this);
        r.setA(this.getA() - n.getA());
        r.setB(this.getB() - n.getB());
        return r;
    }

    public ComplexNum multiplicacao(ComplexNum n) {
        ComplexNum r = new ComplexNum(this);
        r.setA(this.getA() * n.getA() - this.getB() * n.getB());
        r.setB(this.getA() * n.getB() + this.getB() * n.getA());
        return r;
    }

    public ComplexNum divisao(ComplexNum n) {
        ComplexNum r = new ComplexNum(this);
        ComplexNum s = new ComplexNum(n);
        r = r.multiplicacao(n.conjugado());
        s = s.multiplicacao(n.conjugado());
        r.setA(r.getA() / s.getA());
        r.setB(r.getB() / s.getA());
        return r;
    }
}

