/*
Copyright (c) 2009, João Paulo Just Peixoto <just@rg3.net>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package com.blogspot.jpjust;

public class ComplexNum {

	// Um número complexo tem a forma a + bi
	private double a;
	private double b;
	
	// Construtor padrão
	public ComplexNum() {
		this.a = 0;
		this.b = 0;
	}
	
	// Construtor a partir de a e b
	public ComplexNum(double a, double b) {
		this.a = a;
		this.b = b;
	}
	
	// Construtor a partir de outro número complexo
	public ComplexNum(ComplexNum n) {
		this.a = n.getA();
		this.b = n.getB();
	}
	
	// Métodos getters e setters
	public void setA(double a) {
		this.a = a;
	}
	public double getA() {
		return a;
	}
	public void setB(double b) {
		this.b = b;
	}
	public double getB() {
		return b;
	}

	// Módulo de um número complexo
	public double modulo() {
		return Math.sqrt(Math.pow(this.getA(), 2) + Math.pow(this.getB(), 2));
	}
	
	// Conjugado de um número complexo
	public ComplexNum conjugado() {
		ComplexNum r = new ComplexNum(this);
		r.setB(this.getB() * (-1));
		return r;
	}
	
	// Soma de um número complexo
	public ComplexNum soma(ComplexNum n) {
		ComplexNum r = new ComplexNum(this);
		r.setA(this.getA() + n.getA());
		r.setB(this.getB() + n.getB());
		return r;
	}

	// Subtração de um número complexo
	public ComplexNum subtracao(ComplexNum n) {
		ComplexNum r = new ComplexNum(this);
		r.setA(this.getA() - n.getA());
		r.setB(this.getB() - n.getB());
		return r;
	}
	
	// Muiltiplicação de um número complexo
	public ComplexNum multiplicacao(ComplexNum n) {
		ComplexNum r = new ComplexNum(this);
		r.setA((this.getA() * n.getA()) - (this.getB() * n.getB()));
		r.setB((this.getA() * n.getB()) + (this.getB() * n.getA()));
		return r;
	}
	
	// Divisão de um número complexo
	public ComplexNum divisao(ComplexNum n) {
		ComplexNum r = new ComplexNum(this);
		ComplexNum s = new ComplexNum(n);
		r = r.multiplicacao(n.conjugado());
		s = s.multiplicacao(n.conjugado());
		r.setA(r.getA() / s.getA());
		r.setB(r.getB() / s.getA());
		return r;
	}

}
