/*
Copyright (c) 2009, João Paulo Just Peixoto <just@rg3.net>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package com.blogspot.jpjust;

import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class GUI extends JFrame {

	private static final long serialVersionUID = 1L;
	private JTextField txt_a1, txt_b1;
	private JTextField txt_a2, txt_b2;
	private JTextField txt_pot;
	private JButton btn_calc;

	// Desenha a janela do programa
	public void CriaJanela() {
		// Cria e configura painéis
		JPanel painel01 = new JPanel(new FlowLayout());
		JPanel painel02 = new JPanel(new FlowLayout());
		JPanel painel03 = new JPanel(new FlowLayout());
		JPanel painel04 = new JPanel(new FlowLayout());
		setLayout(new GridLayout(5, 1));
		
		// Cria os widgets
		JLabel lb_a1 = new JLabel("Impedância do cabo:");
		JLabel lb_b1 = new JLabel("+ j");
		JLabel lb_a2 = new JLabel("Impedância da antena:");
		JLabel lb_b2 = new JLabel("+ j");
		JLabel lb_pot = new JLabel("Potência do rádio em mW:");
		JLabel lb_about = new JLabel("<html><strong>Casamento de impedâncias<br>" +
				"Por: João Paulo Just &lt;just@rg3.net&gt;<br>" +
				"http://jpjust.blogspot.com</strong></html>");
		
		// Cria os widgets estáticos
		txt_a1 = new JTextField(5);
		txt_b1 = new JTextField(5);
		txt_a2 = new JTextField(5);
		txt_b2 = new JTextField(5);
		txt_pot = new JTextField(5);
		btn_calc = new JButton("Calcular");
		btn_calc.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				calcula();
			}
		});
		
		// Adiciona os widgets nos painéis
		painel01.add(lb_a1);
		painel01.add(txt_a1);
		painel01.add(lb_b1);
		painel01.add(txt_b1);
		painel02.add(lb_a2);
		painel02.add(txt_a2);
		painel02.add(lb_b2);
		painel02.add(txt_b2);
		painel03.add(lb_pot);
		painel03.add(txt_pot);
		painel04.add(btn_calc);
		
		// Adiciona os painéis e configura o JFrame
		add(painel01);
		add(painel02);
		add(painel03);
		add(painel04);
		add(lb_about);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setResizable(false);
		setVisible(true);
		pack();
	}
	
	// Construtor
	public GUI() {
		super("Casamento de impedâncias");
		CriaJanela();
	}
	
	// Efetua o cálculo
	public void calcula() {
		try {
			ComplexNum Zo = new ComplexNum(Double.valueOf(txt_a1.getText()), Double.valueOf(txt_b1.getText()));
			ComplexNum Zt = new ComplexNum(Double.valueOf(txt_a2.getText()), Double.valueOf(txt_b2.getText()));
			
			// Gama = (Zt - Zo) / (Zt + Zo)
			// ROE = (1 + |Gama|) / (1 - |Gama|)
			// Potencia = (4 * ROE) / (1 + ROE)^2
			ComplexNum gama = Zt.subtracao(Zo).divisao(Zt.soma(Zo));
			Double roe = (1 + gama.modulo()) / (1 - gama.modulo());
			if (roe < 0)
				roe *= -1;
			Double potencia = (4 * roe) / Math.pow(1 + roe, 2);
			Double saida = Double.valueOf(txt_pot.getText()) * potencia;
			
			// Mostra o resultado
			JOptionPane.showMessageDialog(this,
				"ROE: " + roe +
				"\nPotência emitida pela antena: " + (potencia * 100) + "%" +
				"\nSinal incidente na antena: " + saida + " mW");
		} catch (NumberFormatException e) {
			JOptionPane.showMessageDialog(this, "Por favor, insira apenas números nos campos.");
		}
	}
	
	// Método principal
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		new GUI();
	}

}
