<?
require_once('func.php');
require_once('config.php');
cabecalho($titulo);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>Google Maps JavaScript API Example: Simple Map</title>

    <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=AIzaSyAcIOpxgw7jkr9x5tiMUr8_UQ7qQ4cK1oI"
	type="text/javascript"></script>
    <script src="mapiconmaker.js" type="text/javascript"></script>	
    <script type="text/javascript">
    var marker;

    var iconRed = new GIcon(); 
    iconRed.image = 'images/mm_20_red.png';
    iconRed.shadow = 'images/mm_20_shadow.png';
    iconRed.iconSize = new GSize(10, 14);
    iconRed.shadowSize = new GSize(18, 16);
    iconRed.iconAnchor = new GPoint(2, 12);
    iconRed.infoWindowAnchor = new GPoint(4, 1);

    var iconGreen = new GIcon(); 
    iconGreen.image = 'images/mm_20_green.png';
    iconGreen.shadow = 'images/mm_20_shadow.png';
    iconGreen.iconSize = new GSize(10, 14);
    iconGreen.shadowSize = new GSize(18, 16);
    iconGreen.iconAnchor = new GPoint(2, 12);
    iconGreen.infoWindowAnchor = new GPoint(4, 1);

    var customIcons = [];
    customIcons["off"] = iconRed;
    customIcons["ong"] = iconGreen;
                
    function initialize() {
      if (GBrowserIsCompatible()) {
        var map = new GMap2(document.getElementById("map"));
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
        map.setCenter(new GLatLng(-21.778366, -41.936802), 12);

        GDownloadUrl("phpsqlajax_genxml2.php", function(data) {
          var xml = GXml.parse(data);
	var markers = xml.documentElement.getElementsByTagName("marker");
          for (var i = 0; i < markers.length; i++) {
            var name = markers[i].getAttribute("name");
	    var login = markers[i].getAttribute("login");
            var address = markers[i].getAttribute("address");
	    var setor = markers[i].getAttribute("setor");
            var type = markers[i].getAttribute("type");
            var ip = markers[i].getAttribute("ip");
            var point = new GLatLng(parseFloat(markers[i].getAttribute("lat")),
                                    parseFloat(markers[i].getAttribute("lng")));
            var marker = createMarker(point, name, login, address, type, setor, ip);
            map.addOverlay(marker);
          }
        });

        GEvent.addListener(map, "click", function(overlay, latlng) {
          if (latlng) {
            marker = new GMarker(latlng, {draggable:true});
            GEvent.addListener(marker, "click", function() {
              var html = "<table>" +
                         "<tr><td>Nome:</td> <td><input type='text' id='name'/> </td> </tr>" +
			 "<tr><td>Login:</td> <td><input type='text' id='login'/> </td> </tr>" +
                         "<tr><td>Endereco:</td> <td><input type='text' id='address'/></td> </tr>" +
                         "<tr><td>IP:</td> <td><input type='text' id='ip'/></td> </tr>" +
                         "<tr><td>Type:</td> <td><select id='type'>" +
                         "<option value='on' SELECTED>ON</option>" +
                         "<option value='off'>OFF</option>" +
                         "</select> </td></tr>" +
                         "<tr><td></td><td><input type='button' value='Save & Close' onclick='saveData()'/></td></tr>" +
			 "</table>";

              marker.openInfoWindow(html);
            });
	    map.addOverlay(marker);
          }
        });

      }
    }

    function saveData() {
      var name = escape(document.getElementById("name").value);
      var address = escape(document.getElementById("address").value);
      var login = escape(document.getElementById("login").value);
      var ip = escape(document.getElementById("ip").value);
      var type = document.getElementById("type").value;
      var latlng = marker.getLatLng();
      var lat = latlng.lat();
      var lng = latlng.lng();

      var url = "phpsqlinfo_addrow.php?name=" + name + "&login=" + login + "&address=" + address + "&ip=" + ip +
    		"&type=" + type + "&lat=" + lat + "&lng=" + lng +"";
      GDownloadUrl(url, function(data, responseCode) {
        if (responseCode == 200 && data.length <= 1) {
          marker.closeInfoWindow();
          document.getElementById("message").innerHTML = "Cadastrado com Sucesso.";
        }
      });
    }
    
    function createMarker(point, name, login, address, type, setor, ip) {
      var marker = new GMarker(point, customIcons[type]);
      var html = "<table><b>Nome: " + name + "</b><br>Login: " + login + "</br><br>Endereco: " + address + "</br></table>";
      GEvent.addListener(marker, 'click', function() {
        marker.openInfoWindow(html);
      });
    return marker;
      
    }
    
    </script>
  </head>

  <body onload="initialize()" onunload="GUnload()">
    <div id="map" style="width: 950px; height: 550px"></div>
    <div id="message"></div>
  </body>

</html>
