<?php
require_once('func.php');
require_once('config.php');
cabecalho($titulo);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta HTTP-EQUIV="refresh" CONTENT="300">
    <title>Monitoramento de Rotas</title>
    <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=AIzaSyAcIOpxgw7jkr9x5tiMUr8_UQ7qQ4cK1oI" type="text/javascript"></script>
    <script src="mapiconmaker.js" type="text/javascript"></script>
</head>
<body onload="load()" onunload="GUnload()">
<div id="area" style="width: 940px; height: 480px; border: 1px solid black">
</div>
<div id="teste"></div>

<script type="text/javascript">
    //<![CDATA[
    
	var FALHA = "images/mm_20_red.png";
	var NORMAL = "images/mm_20_blue.png";
	var NORMALY = "images/mm_20_yellow.png";	
	var NORMALO = "images/mm_20_green.png";
	var PONTO =  "images/icon_energia.png";
	var REDUND= "images/icon_energia.png";
	var NORMALS = "images/mm_20_shadow.png";
	var NORMALZ = "images/mm_20_white.png";
	var timer;

        var iconOptions = {
        width: "15",
        height: "15",
        primaryColor: "67ff00",
        cornerColor: "67ff00",
        strokeColor: "000000"
        };


	var iconeNormalO= new GIcon();
	iconeNormalO.image=NORMALO;
	iconeNormalO.shadow=NORMALS;
	iconeNormalO.shadowSize = new GSize(11,1);
	iconeNormalO.iconsize= new GSize(1,1);
	iconeNormalO.iconAnchor= new GPoint(2,12);
	iconeNormalO.infoWindowAnchor= new GPoint(4,1);
	iconeNormalO.infoShadowAnchor = new GPoint(1,1);

	var iconeRED= new GIcon();
	iconeRED.shadow=NORMALS;
	iconeRED.image=FALHA;
	iconeRED.iconsize= new GSize(1,1);
	iconeRED.iconAnchor = new GPoint(2,12);
	iconeRED.infoWindowAnchor= new GPoint(4,1);	

    var map=new Array();
    //null;
    var mapContainer=new Array();
    //null;
    var msgContainer=new Array();
    //null;    
    var ponto;
    var vez = 0;
    var customIcons=[];


    customIcons["O"]= iconeNormalO;    
    customIcons["F"]= iconeRED;

    var markerGroups= null;

    
function load()
    {
      if (GBrowserIsCompatible()) 
	{
	    var CENTER = new GLatLng(-21.778366, -41.936802);
    	    map = new GMap2(document.getElementById("area"));
	    map.addControl(new GLargeMapControl());
	    map.addControl(new GMapTypeControl());
	    map.enableContinuousZoom();
	    map.setCenter(CENTER, 12);
	    
	    draw();
    }
}    

function draw()
{
    reDraw();
}

function reDraw() {
	    
markerGroups= { "O" : [], "F" : []};

    GDownloadUrl("phpsqlajax_genxml3.php",function(data)
	      {
		    var xml=GXml.parse(data)
		    var marcadores = xml.documentElement.getElementsByTagName("username");

		    map.clearOverlays();
		    for (var i = 0; i < marcadores.length; i++)
	    	     {
			var username = marcadores[i].getAttribute("login"); 
			var lat = parseFloat(marcadores[i].getAttribute("lat"));
			var lon = parseFloat(marcadores[i].getAttribute("lng"));
			var tipo = marcadores[i].getAttribute("icone");
    			var ponto = new GLatLng(lat,lon); //var
			var address = marcadores[i].getAttribute("address");
			var nome = marcadores[i].getAttribute("name");
			
			var marker = createMarker(ponto,username,lat,lon,tipo,address,nome);
			map.addOverlay(marker);

	    	     } // fim do for


	    }); // fim do readystatechange
    } // fim reDraw

/////////////////

function createMarker(ponto,username,lat,lon,tipo,address,nome)
{
 var marker = new GMarker(ponto, {icon: customIcons[tipo], draggable: true});
      markerGroups[tipo].push(marker);
      
      var diario = null; 
      var semanal = null;
      var mensal = null;
      var anual = null;
            
      var html = "<table>" +
    		 "<b>Nome: </b>" + nome + "<br/><br/>" +
		 "<b>Endereco: </b>" + address + "<br/><br/>" +
    		 "<b>Login: </b>" + username + "<br/><br/>" + 
		 "<b>Latitude: </b>" + lat +"<br/>" +
		 "<b>Longitude: </b>"+ lon + "<br/>" +
		 "</table>";
		 
      GEvent.addListener(marker, 'click', function() {
	    marker.openInfoWindowHtml(html)
      });

      GEvent.addListener(marker, 'dragstart', function() {
	stopTimer('Stop');
        marker.closeInfoWindow();
      });

      GEvent.addListener(marker, 'removeoverlay', function() {
      });

      GEvent.addListener(marker, 'dragend', function() {
	stopTimer('Start');
        marker.openInfoWindowHtml(html);
      });

  return marker;
}


function toggleGroup(type)
 {
    stopTimer('Stop');

      for (var i = 0; i < markerGroups[type].length; i++) 
        {
              var marker = markerGroups[type][i];
        	  if (marker.isHidden()) 
		    {
	            marker.show();
		    } 
		 else 
		    {
		      marker.hide();
		    }
	} 

}

function submitForm(frm)
{
    var campos={
	    username:  'O campo usurio no foi preenchido',
	    lat: 'Preenchido incorretamente',
	    lng: 'Prenchido incorretamente',
	    tipo : 'Preenchido Incorretamente'
	    };
	    
    var erro = []; 	    
    var values = 'ajax=1';

    for (campo in campos)
	{
	    val = frm[campo].value;
	    if (trim(val).length == 0)
		erro[erro.length] = campos[campo];
		
		values+='&' + campo + '=' + escape(val);
	} 
	if (erro.length > 0) 
	    {
		var errMsg='<strong>Os Seguintes erros foram encontrados:</strong>';
			     + '<br /><ul> \n';
			  
		  for (var i=0; i < erro.length; i++)
			    {
				errMsg += '<li>' + erro[i] + '<li>\n';
			    } 
		errMsg += '</ul>\n';
		
		showMessage(errMsg);
		return false;
	}
	

    var xmlhttp=GXmlHttp.create();
    xmlhttp.open("POST", frm.action, true);
    xmlhttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
    xmlhttp.onreadystatechange = function() 
		{
		    if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
			{
			    showMessage(xmlhttp.responseText);
		        }
		}
	xmlhttp.send(values);
	setTimeout("reDraw()", 1000);

}

function stopTimer(param){

tempo = parseInt(document.getElementById('delay').value) * 100000;

if (param == 'Stop'){
    clearInterval(timer);
    document.getElementById('Start').disabled=false;
    document.getElementById('Stop').disabled=true;
    }
else
    {
    timer=setInterval("reDraw()",tempo);
    document.getElementById('Start').disabled=true;
    document.getElementById('Stop').disabled=false;
    }
}

function ShowMessage(msg)
{
	if (msg.lenght == 0)
	    msgContainer.style.display = 'none';
	else 
	    {
		msgContainer.innerHTML=msg;
		msgContainer.style.display= 'block';
	    }
} 


function trim(str)
{
    return str.replace(/^(\s+)?(\S*) (\s+)?$/, '$2u');
}

function getXmlHttp()
{
  try { return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP"); }
    catch (e) { try { return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP"); }
		catch(E) { xmlhttp=false;}
		}
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
    	    try	{ xmlhttp = new XMLHttpRequest(); }
	    catch (e) { alert('Este Browser Nao suporta AJAX');
			xmlhttp=false;
			}
		}	
	return xmlhttp;
}	

    

    //]]>
</script>
</body>
</html>
