unit gbCob237;

interface

uses
   classes, SysUtils, gbCobranca
   {$IFDEF VER150}
      , Variants, MaskUtils, contnrs, DateUtils
   {$ELSEIF VER140}
      , Variants, MaskUtils, contnrs, DateUtils
   {$ELSE}
      {$IFDEF VER130}
         , Mask, contnrs
      {$ELSE}
         , Mask
      {$ENDIF}
   {$IFEND}
   ;

const
   CodigoBanco = '237';
   NomeBanco = 'BRADESCO';

type

   TgbBanco237 = class(TPersistent)
{$IFNDEF VER120}
   private
      function VerificaOcorrenciaOriginal(sOcorrenciaOriginal: String): String;
      function VerificaMotivoRejeicaoComando(sMotivoRejeicaoComando: String): String;
    //function GerarRemessaCNAB240(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
      function GerarRemessaCNAB400(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
    //function LerRetornoCNAB240(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
      function LerRetornoCNAB400(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
{$ENDIF}
   published
      function  GetNomeBanco   : string; {Retorna o nome do banco}
      function  GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string; {Retorna o contedo da parte varivel do cdigo de barras}
      function  CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string; {Calcula o dgito do NossoNumero, conforme critrios definidos por cada banco}
      procedure FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string); {Define o formato como alguns valores sero apresentados no boleto }
{$IFNDEF VER120}
      function  LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean; {L o arquivo retorno recebido do banco}
      function  GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean; {Gerar arquivo remessa para enviar ao banco}
{$ENDIF}
   end;


implementation


function TgbBanco237.GetNomeBanco : string;
begin
   Result := NomeBanco;
end;

function TgbBanco237.CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string;
var
   ACarteira,
   ANossoNumero,
   ADigitoNossoNumero : string;
begin
   Result := '0';

   with ATitulo do
   begin
      ACarteira := Formatar(Carteira,2,false,'0');
      ANossoNumero := Formatar(NossoNumero,11,false,'0');
      ADigitoNossoNumero := Modulo11(ACarteira + ANossoNumero,7,true);
   end;
   if StrToInt(ADigitoNossoNumero) = 1 then
      ADigitoNossoNumero := 'P'
   else if StrToInt(ADigitoNossoNumero) > 1 then
      ADigitoNossoNumero := IntToStr(11 - StrToInt(ADigitoNossoNumero));

   Result := ADigitoNossoNumero;
end;

function TgbBanco237.GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string;
var
   AAnoAtual,
   ACarteira,
   ANossoNumero,
   ACodigoAgencia,
   ANumeroConta: string;
begin

   {
    A primeira parte do cdigo de barras ser calculada automaticamente.
    Ela  composta por:
    Cdigo do banco (3 posies)
    Cdigo da moeda = 9 (1 posio)
    Dgito do cdigo de barras (1 posio) - Ser calculado e includo pelo componente
    Fator de vencimento (4 posies) - Obrigatrio a partir de 03/07/2000
    Valor do documento (10 posies) - Sem vrgula decimal e com ZEROS  esquerda

    A segunda parte do cdigo de barras  um campo livre, que varia de acordo
    com o banco. Esse campo livre ser calculado por esta funo (que voc dever
    alterar de acordo com as informaes fornecidas pelo banco).
   }

   {Segunda parte do cdigo de barras - Campo livre - Varia de acordo com o banco}

   with ATitulo do
   begin
      ACarteira := Formatar(Carteira,2,false,'0');
      AAnoAtual := FormatDateTime('yy',Now());
      ANossoNumero := Formatar(NossoNumero,9,false,'0');
      ACodigoAgencia := Formatar(Cedente.ContaBancaria.CodigoAgencia,4,false,'0');
      ANumeroConta := Formatar(Cedente.ContaBancaria.NumeroConta,7,false,'0');
   end;

   Result := ACodigoAgencia + ACarteira + AAnoAtual + ANossoNumero + ANumeroConta + '0';
end;

procedure TgbBanco237.FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string);
begin
   with ATitulo do
   begin
      AAgenciaCodigoCedente := Formatar(Cedente.ContaBancaria.CodigoAgencia,4,false,'0') + '/' + Formatar(Cedente.CodigoCedente,7,false,'0') + '-' + Cedente.DigitoCodigoCedente;
      ANossoNumero := Formatar(Carteira,3,false,'0') + '/' + Formatar(Cedente.ContaBancaria.CodigoAgencia,4,false,'0') + '/' + Formatar(NossoNumero,7,false,'0') + '-' + DigitoNossoNumero;
      ACarteira := Formatar(Carteira,3,false,'0');
      AEspecieDocumento := '';
   end;
end;

{$IFNDEF VER120}

function TgbBanco237.GerarRemessaCNAB400(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
var
   ACedenteTipoInscricao, ASacadoTipoInscricao,
   Registro : string;
   NumeroRegistro : integer;
begin
   Result := FALSE;
   NumeroRegistro := 0;
   Remessa.Clear;

   with ACobranca do
   begin

      { GERAR REGISTRO-HEADER DA REMESSA }

      Remessa.Add('01REMESSA01'+Formatar('COBRANCA',15)+'000'+Formatar(Titulos[NumeroRegistro].Carteira,4,false,'0')+Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.CodigoAgencia,5,false,'0')+Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.NumeroConta,7,false,'0')+Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.DigitoConta,1)+Formatar(Titulos[NumeroRegistro].Cedente.Nome,30,true,' ')+Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.Banco.Codigo,3,false,'0')+Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.Banco.Nome,15,true,' ')+FormatDateTime('ddmmyy',DataArquivo)+Formatar('',8)+'MX'+Formatar(IntToStr(NumeroArquivo),7,false,'0')+Formatar('',277)+'000001');

      { GERAR TODOS OS REGISTROS DETALHE DA REMESSA }
      while NumeroRegistro <= (Titulos.Count - 1) do
      begin
         if Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.Banco.Codigo,3,false,'0') <> Formatar(CodigoBanco,3,false,'0') then
            Raise Exception.CreateFmt('Titulo no pertence ao banco %s - %s',[CodigoBanco,NomeBanco]);

         case Titulos[NumeroRegistro].Cedente.TipoInscricao of
            tiPessoaFisica  : ACedenteTipoInscricao := '01';
            tiPessoaJuridica: ACedenteTipoInscricao := '02';
            tiOutro         : ACedenteTipoInscricao := '03';
         end;
         case Titulos[NumeroRegistro].Sacado.TipoInscricao of
            tiPessoaFisica  : ASacadoTipoInscricao := '01';
            tiPessoaJuridica: ASacadoTipoInscricao := '02';
            tiOutro         : ASacadoTipoInscricao := '03';
         end;

         Registro := '1';
         Registro := Registro + Formatar('',19,false,'0');
         Registro := Registro + '0'+Formatar(Titulos[NumeroRegistro].Carteira,3,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.CodigoAgencia,5,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.NumeroConta,7,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.DigitoConta,1);
         Registro := Registro + Formatar(Titulos[NumeroRegistro].SeuNumero,25,true,' ');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.Banco.Codigo,3,false,'0');

         //**// estavam faltando estes cinco zeros...
         Registro := Registro + '00000';

         Registro := Registro + Formatar(Titulos[NumeroRegistro].NossoNumero,11,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].DigitoNossoNumero,1,false,'0');
         Registro := Registro + Formatar('',10,false,'0');
         Registro := Registro + '1N';
         Registro := Registro + Formatar('',11);
         Registro := Registro + '2';
         Registro := Registro + Formatar('',2);
         Registro := Registro + '01';
         Registro := Registro + Formatar(Titulos[NumeroRegistro].SeuNumero,10);
         Registro := Registro + FormatDateTime('ddmmyy',Titulos[NumeroRegistro].DataVencimento);
         Registro := Registro + FormatCurr('0000000000000',Titulos[NumeroRegistro].ValorDocumento * 100);
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Cedente.ContaBancaria.Banco.Codigo,3,false,'0');
         Registro := Registro + Formatar('',5,false,'0');
         Registro := Registro + '05';
         Registro := Registro + 'N';
         Registro := Registro + FormatDateTime('ddmmyy',Titulos[NumeroRegistro].DataDocumento);
         Registro := Registro + Formatar(' ',4);
         Registro := Registro + Formatar(' ',13,false,'0');
         Registro := Registro + Formatar(' ',6);
         Registro := Registro + Formatar(' ',13,false,'0');
         Registro := Registro + Formatar(' ',13,false,'0');
         Registro := Registro + Formatar(' ',13,false,'0');
         Registro := Registro + Formatar(ASacadoTipoInscricao,2,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Sacado.NumeroCPFCGC,14,false,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Sacado.Nome,40);
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Sacado.Endereco.Rua+' '+Titulos[NumeroRegistro].Sacado.Endereco.Numero+' '+Titulos[NumeroRegistro].Sacado.Endereco.Complemento+' '+Titulos[NumeroRegistro].Sacado.Endereco.Bairro+' '+Titulos[NumeroRegistro].Sacado.Endereco.Cidade+' '+Titulos[NumeroRegistro].Sacado.Endereco.Estado,40);
         Registro := Registro + Formatar('',12);
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Sacado.Endereco.CEP,8,true,'0');
         Registro := Registro + Formatar(Titulos[NumeroRegistro].Instrucoes.Text,60);
         Registro := Registro + Formatar(IntToStr(NumeroRegistro+2),6,false,'0');
          Remessa.Add(Registro);
         NumeroRegistro := NumeroRegistro + 1;
      end;

      { GERAR REGISTRO TRAILER DA REMESSA }

      Remessa.Add('9'+Formatar('',393,true,' ')+Formatar(IntToStr(NumeroRegistro+2),6,false,'0'));
   end;

   Result := TRUE;
end;

function  TgbBanco237.GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
begin
   case ACobranca.LayoutArquivo of
      laCNAB240 : Raise Exception.CreateFmt('A gerao de arquivo de remessa para o %s no est est disponvel para o layout laCNAB240',[NomeBanco]);
      laCNAB400 : Result := GerarRemessaCNAB400(ACobranca, Remessa)
   else
      begin
         Result := FALSE;
         Raise Exception.Create('Layout de arquivo invlido. Diferente de laCNAB400');
      end; {else}
   end; {case}
end;


function TgbBanco237.LerRetornoCNAB400(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
var
   ACodigoBanco,
   ANomeCedente,
   ATipoInscricao : string;
   NumeroRegistro : integer;
   ATitulo : TgbTitulo;
begin
   NumeroRegistro := 0;
   ATitulo := TgbTitulo.Create(nil);

   TRY

      with ACobranca do
      begin
         Titulos.Clear; {Zera o conjunto de ttulos, antes de incluir os ttulos do arquivo retorno}

         if Retorno.Count <= 0 then
            Raise Exception.Create('O retorno est vazio. No h dados para processar');

         {Ver se o arquivo  mesmo RETORNO DE COBRANA}
         if Copy(Retorno.Strings[NumeroRegistro],1,19) <> '02RETORNO01COBRANCA' then
            Raise Exception.Create(NomeArquivo+' no  um arquivo de retorno de cobrana');

         { L registro HEADER}
         ACodigoBanco := Copy(Retorno.Strings[NumeroRegistro],77,3);
         if ACodigoBanco <> CodigoBanco then
            Raise Exception.CreateFmt('Este no  um retorno de cobrana do banco %s - %s',[CodigoBanco,NomeBanco]);

         ANomeCedente := Trim(Copy(Retorno.Strings[NumeroRegistro],47,30));
         if StrToInt(Copy(Retorno.Strings[NumeroRegistro],99,2)) <= 69 then
            DataArquivo := EncodeDate(StrToInt('20'+Copy(Retorno.Strings[NumeroRegistro],99,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],97,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],95,2)))
         else
            DataArquivo := EncodeDate(StrToInt('19'+Copy(Retorno.Strings[NumeroRegistro],99,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],97,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],95,2)));

         NumeroArquivo := StrToInt(Trim(Copy(Retorno.Strings[NumeroRegistro],109,5)));

         {L os registros DETALHE}
         {Processa at o penltimo registro porque o ltimo contm apenas o TRAILLER}
         for NumeroRegistro := 1 to (Retorno.Count - 2) do
         begin
            {Confirmar se o tipo do registro  1}
            if Copy(Retorno.Strings[NumeroRegistro],1,1) <> '1' then
               Continue; {No processa o registro atual}

            { Ler ttulos do arquivo retorno}
            {Dados do titulo}
            with ATitulo do
            begin
               {Dados do cedente do ttulo}
               with Cedente do
               begin
                  ATipoInscricao := Copy(Retorno.Strings[NumeroRegistro],2,2);
                  if ATipoInscricao = '01' then
                     TipoInscricao := tiPessoaFisica
                  else if ATipoInscricao = '02' then
                     TipoInscricao := tiPessoaJuridica
                  else
                     TipoInscricao := tiOutro;
                  NumeroCPFCGC := Copy(Retorno.Strings[NumeroRegistro],4,14);
                  ContaBancaria.Banco.Codigo := ACodigoBanco;
                  Nome := ANomeCedente;
               end; {with ACedente}

               NumeroDocumento := Copy(Retorno.Strings[NumeroRegistro],38,25);

               {Tipo de ocorrncia}
               OcorrenciaOriginal := Copy(Retorno.Strings[NumeroRegistro],109,2); //@w
               DescricaoOcorrenciaOriginal := VerificaOcorrenciaOriginal(OcorrenciaOriginal); //@w               
               case StrToInt(OcorrenciaOriginal) of
                  02: TipoOcorrencia := toRetornoRegistroConfirmado;
                  03: TipoOcorrencia := toRetornoRegistroRecusado;
                  06: TipoOcorrencia := toRetornoLiquidado;
                  09: TipoOcorrencia := toRetornoBaixado;
                  10: TipoOcorrencia := toRetornoBaixado;
                  11: TipoOcorrencia := toRetornoTituloEmSer;
                  12: TipoOcorrencia := toRetornoAbatimentoConcedido;
                  13: TipoOcorrencia := toRetornoAbatimentoCancelado;
                  14: TipoOcorrencia := toRetornoVencimentoAlterado;
                  15: TipoOcorrencia := toRetornoLiquidadoEmCartorio;
                  17: TipoOcorrencia := toRetornoLiquidadoSemRegistro;
                  18: TipoOcorrencia := toRetornoAcertoDepositaria;
                  19: TipoOcorrencia := toRetornoRecebimentoInstrucaoProtestar;
                  20: TipoOcorrencia := toRetornoRecebimentoInstrucaoSustarProtesto;
                  21: TipoOcorrencia := toRetornoDadosAlterados;
                  23: TipoOcorrencia := toRetornoEncaminhadoACartorio;
                  24: TipoOcorrencia := toRetornoRegistroRecusado;
                  27: TipoOcorrencia := toRetornoComandoRecusado;
                  28: TipoOcorrencia := toRetornoDebitoTarifas;
                  30: TipoOcorrencia := toRetornoComandoRecusado;
                  32: TipoOcorrencia := toRetornoComandoRecusado;
                  33: TipoOcorrencia := toRetornoRecebimentoInstrucaoAlterarDados;
                  34: TipoOcorrencia := toRetornoRetiradoDeCartorio;
                  99: TipoOcorrencia := toRetornoRegistroRecusado;
               else
                  TipoOcorrencia := toRetornoOutrasOcorrencias;
               end; {case StrToInt(ATipoOcorrencia)}

               if (TipoOcorrencia = toRetornoRegistroRecusado) or (TipoOcorrencia = toRetornoComandoRecusado) then
               begin
                  MotivoRejeicaoComando := Copy(Retorno.Strings[NumeroRegistro],319,2);
                  case StrToInt(MotivoRejeicaoComando) of
                     00 : DescricaoMotivoRejeicaoComando := '00 - Ocorrencia aceita';
                     17 : DescricaoMotivoRejeicaoComando := '17 - Data de vencimento anterior a data de emisso';
                     21 : DescricaoMotivoRejeicaoComando := '21 - Espcie do Ttulo invlido';
                     24 : DescricaoMotivoRejeicaoComando := '24 - Data da emisso invlida';
                     38 : DescricaoMotivoRejeicaoComando := '38 - Prazo para protesto invlido';
                     39 : DescricaoMotivoRejeicaoComando := '39 - Pedido para protesto no permitido para ttulo';
                     43 : DescricaoMotivoRejeicaoComando := '43 - Prazo para baixa e devoluo invlido';
                     45 : DescricaoMotivoRejeicaoComando := '45 - Nome do Sacado invlido';
                     46 : DescricaoMotivoRejeicaoComando := '46 - Tipo/num. de inscrio do Sacado invlidos';
                     47 : DescricaoMotivoRejeicaoComando := '47 - Endereo do Sacado no informado';
                     48 : DescricaoMotivoRejeicaoComando := '48 - CEP irregular';
                     50 : DescricaoMotivoRejeicaoComando := '50 - CEP referente a Banco correspondente';
                     53 : DescricaoMotivoRejeicaoComando := '53 - N de inscrio do Sacador/avalista invlidos  (CPF/CGC)';
                     54 : DescricaoMotivoRejeicaoComando := '54 - Sacador/avalista no informado';
                     67 : DescricaoMotivoRejeicaoComando := '67 - Dbito automtico agendado';
                     68 : DescricaoMotivoRejeicaoComando := '68 - Dbito no agendado - erro nos dados de remessa';
                     69 : DescricaoMotivoRejeicaoComando := '69 - Dbito no agendado - Sacado no consta no cadastro de autorizante';
                     70 : DescricaoMotivoRejeicaoComando := '70 - Dbito no agendado - Cedente no autorizado pelo Sacado';
                     71 : DescricaoMotivoRejeicaoComando := '71 - Dbito no agendado - Cedente no participa da modalidade de dbito automtico';
                     72 : DescricaoMotivoRejeicaoComando := '72 - Dbito no agendado - Cdigo de moeda diferente de R$';
                     73 : DescricaoMotivoRejeicaoComando := '73 - Dbito no agendado -  Data de vencimento invlida';
                     75 : DescricaoMotivoRejeicaoComando := '75 - Dbito no agendado - Tipo do nmero de inscrio do sacado debitado invlido';
                     86 : DescricaoMotivoRejeicaoComando := '86 - Seu nmero do documento invlido'
                  else
                     MotivoRejeicaoComando := MotivoRejeicaoComando + ' - Outros motivos'
                  end; {case MotivoRejeicaoComando of}
               end; {if TipoOcorrencia...}

               if StrToInt(Copy(Retorno.Strings[NumeroRegistro],115,2)) <= 69 then
                  DataOcorrencia := EncodeDate(StrToInt('20'+Copy(Retorno.Strings[NumeroRegistro],115,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],113,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],111,2)))
               else
                  DataOcorrencia := EncodeDate(StrToInt('19'+Copy(Retorno.Strings[NumeroRegistro],115,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],113,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],111,2)));
               ValorDocumento := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],153,13))/100;
               ValorIOF := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],215,13))/100;
               ValorAbatimento := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],228,13))/100;
               ValorDesconto := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],241,13))/100;
               ValorMoraJuros := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],267,13))/100;
               ValorOutrosCreditos := StrToFloat(Trim(Copy(Retorno.Strings[NumeroRegistro],280,13)))/100;

               {Dados que variam de acordo com o banco}

               {Nosso nmero SEM DGITO}
               NossoNumero := Copy(Retorno.Strings[NumeroRegistro],71,11);
               Carteira := Copy(Retorno.Strings[NumeroRegistro],22,3);

               //**// estava ,24,5
               Cedente.ContaBancaria.CodigoAgencia := Copy(Retorno.Strings[NumeroRegistro],25,5);

               //**// estava ,29,7
               Cedente.ContaBancaria.NumeroConta := Copy(Retorno.Strings[NumeroRegistro],30,7);

               //**// estava ,30,1
               Cedente.ContaBancaria.DigitoConta := Copy(Retorno.Strings[NumeroRegistro],37,1);

               ValorDespesaCobranca := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],176,13))/100;
               ValorOutrasDespesas := StrToFloat(Copy(Retorno.Strings[NumeroRegistro],189,13))/100;
               if Formatar(Copy(Retorno.Strings[NumeroRegistro],296,6),6,false,'0') <> '000000' then
                  if StrToInt(Copy(Retorno.Strings[NumeroRegistro],300,2)) <= 69 then
                     DataCredito := EncodeDate(StrToInt('20'+Copy(Retorno.Strings[NumeroRegistro],300,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],298,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],296,2)))
                  else
                     DataCredito := EncodeDate(StrToInt('19'+Copy(Retorno.Strings[NumeroRegistro],300,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],298,2)),StrToInt(Copy(Retorno.Strings[NumeroRegistro],296,2)));

            end; {with ATitulo}

            {Insere o ttulo}
            Titulos.Add(ATitulo);
         end;
      end;

      ATitulo.Free;
      Result := TRUE
   EXCEPT
      ATitulo.Free;
      Result := FALSE;
      Raise; {Propaga o erro}
   END;
end;

function TgbBanco237.LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
var
   ACodigoBanco,
   ANomeCedente,
   ATipoInscricao : string;
   NumeroRegistro : integer;
   ATitulo : TgbTitulo;
begin
   NumeroRegistro := 0;
   ATitulo := TgbTitulo.Create(nil);

   TRY

      with ACobranca do
      begin
         Titulos.Clear; {Zera o conjunto de ttulos, antes de incluir os ttulos do arquivo retorno}

         if Retorno.Count <= 0 then
            Raise Exception.Create('O retorno est vazio. No h dados para processar');

         case length(Retorno[0]) of
            240 :
               begin
                  Raise Exception.CreateFmt('A leitura de arquivo de retorno para o %s no est est disponvel para o layout laCNAB240',[NomeBanco]);
{
                  LayoutArquivo := laCNAB240;
                  Result := LerRetornoCNAB240(ACobranca, Retorno);
}
               end;
            400 :
               begin
                  LayoutArquivo := laCNAB400;
                  Result := LerRetornoCNAB400(ACobranca, Retorno);
               end
         else
            begin
               LayoutArquivo := laOutro;
               Raise Exception.CreateFmt('Tamanho de registro invlido: %d',[length(Retorno[0])]);
            end;
         end;
      end;

      ATitulo.Free;
      Result := TRUE
   EXCEPT
      ATitulo.Free;
      Result := FALSE;
      Raise; //Propaga o erro
   END;
end;



function TgbBanco237.VerificaOcorrenciaOriginal(sOcorrenciaOriginal: String): String;
begin
  if sOcorrenciaOriginal='  ' then begin
     Result:='';
     Exit;
  end;

  case StrToInt(sOcorrenciaOriginal) of
    02: Result:='02-Entrada Confirmada' ;
    03: Result:='03-Entrada Rejeitada' ;
    06: Result:='06-Liquidao  normal' ;
    09: Result:='09-Baixado Automaticamente via Arquivo' ;
    10: Result:='10-Baixado conforme instrues da Agncia' ;
    11: Result:='11-Em Ser - Arquivo de Ttulos pendentes' ;
    12: Result:='12-Abatimento Concedido' ;
    13: Result:='13-Abatimento Cancelado' ;
    14: Result:='14-Vencimento Alterado' ;
    15: Result:='15-Liquidao em Cartrio' ;
    17: Result:='17-Liquidao aps baixa ou Ttulo no registrado' ;
    18: Result:='18-Acerto de Depositria' ;
    19: Result:='19-Confirmao Recebimento Instruo de Protesto' ;
    20: Result:='20-Confirmao Recebimento Instruo Sustao de Protesto' ;
    21: Result:='21-Acerto do Controle do Participante' ;
    23: Result:='22-Entrada do Ttulo em Cartrio' ;
    24: Result:='23-Entrada rejeitada por CEP Irregular' ;
    27: Result:='27-Baixa Rejeitada' ;
    28: Result:='28-Dbito de tarifas/custas' ;
    30: Result:='30-Alterao de Outros Dados Rejeitados' ;
    32: Result:='32-Instruo Rejeitada' ;
    33: Result:='33-Confirmao Pedido Alterao Outros Dados' ;
    34: Result:='34-Retirado de Cartrio e Manuteno Carteira' ;
    35: Result:='35-Desagendamento do dbito automtico' ;
    68: Result:='68-Acerto dos dados do rateio de Crdito' ;
    69: Result:='69-Cancelamento dos dados do rateio' ;
  end;
end;

function TgbBanco237.VerificaMotivoRejeicaoComando(sMotivoRejeicaoComando: String): String;
begin
if sMotivoRejeicaoComando='  ' then begin
    Result:='';
    Exit;
end;

case StrToInt(sMotivoRejeicaoComando) of
   02: Result:='02-Cdigo do registro detalhe invlido' ;
   03: Result:='03-Cdigo da ocorrncia invlida' ;
   04: Result:='04-Cdigo de ocorrncia no permitida para a carteira' ;
   05: Result:='05-Cdigo de ocorrncia no numrico' ;
   07: Result:='07-Agncia/conta/Digito - Invlido' ;
   08: Result:='08-Nosso nmero invlido' ;
   09: Result:='09-Nosso nmero duplicado' ;
   10: Result:='10-Carteira invlida' ;
   16: Result:='16-Data de vencimento invlida' ;
   18: Result:='18-Vencimento fora do prazo de operao' ;
   20: Result:='19-Valor do Ttulo invlido' ;
   21: Result:='21-Espcie do Ttulo invlida' ;
   22: Result:='22-Espcie no permitida para a carteira' ;
   24: Result:='24-Data de emisso invlida' ;
   38: Result:='38-Prazo para protesto invlido' ;
   44: Result:='44-Agncia Cedente no prevista' ;
   50: Result:='50-CEP irregular - Banco Correspondente' ;
   63: Result:='63-Entrada para Ttulo j cadastrado' ;
   68: Result:='68-Dbito no agendado - erro nos dados de remessa' ;
   69: Result:='69-Dbito no agendado - Sacado no consta no cadastro de autorizante' ;
   70: Result:='70-Dbito no agendado - Cedente no autorizado pelo Sacado' ;
   71: Result:='71-Dbito no agendado - Cedente no participa da modalidade de dbito automtico' ;
   72: Result:='72-bito no agendado - Cdigo de moeda diferente de R$' ;
   73: Result:='73-Dbito no agendado - Data de vencimento invlida' ;
   74: Result:='74-Dbito no agendado - Conforme seu pedido, Ttulo no registrado' ;
   75: Result:='75-Dbito no agendado - Tipo de nmero de inscrio do debitado invlido' ;
end;
end;

{$ENDIF}

initialization
RegisterClass(TgbBanco237);

end.

