unit gbCob347;

interface

uses
   classes, SysUtils, gbCobranca
   {$IFDEF VER150}
      , Variants, MaskUtils, contnrs, DateUtils
   {$ELSEIF VER140}
      , Variants, MaskUtils, contnrs, DateUtils
   {$ELSE}
      {$IFDEF VER130}
         , Mask, contnrs
      {$ELSE}
         , Mask
      {$ENDIF}
   {$IFEND}
   ;

const
   CodigoBanco = '347';
   NomeBanco = 'SUDAMERIS';

type

   TgbBanco347 = class(TPersistent)
   published
      function  GetNomeBanco   : string; {Retorna o nome do banco}
      function  GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string; {Retorna o contedo da parte varivel do cdigo de barras}
      function  CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string; {Calcula o dgito do NossoNumero, conforme critrios definidos por cada banco}
      procedure FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string); {Define o formato como alguns valores sero apresentados no boleto }
{$IFNDEF VER120}
      function  LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean; {L o arquivo retorno recebido do banco}
      function  GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean; {Gerar arquivo remessa para enviar ao banco}
{$ENDIF}
   end;


implementation


function TgbBanco347.GetNomeBanco : string;
begin
   Result := NomeBanco;
end;

function TgbBanco347.CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string;
var
   ACarteira,
   ANossoNumero,
   ADigitoNossoNumero : string;
begin
   Result := '0';

   ACarteira := Formatar(ATitulo.Carteira,2,false,'0');
   ANossoNumero := Formatar(ATitulo.NossoNumero,6,false,'0');
   ADigitoNossoNumero := Modulo11(ACarteira + ANossoNumero,9);

   Result := ADigitoNossoNumero;
end;

function TgbBanco347.GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string;
var
   ANossoNumero,
   ACodigoAgencia,
   ACodigoCedente: string;
begin

   {
    A primeira parte do cdigo de barras ser calculada automaticamente.
    Ela  composta por:
    Cdigo do banco (3 posies)
    Cdigo da moeda = 9 (1 posio)
    Dgito do cdigo de barras (1 posio) - Ser calculado e includo pelo componente
    Fator de vencimento (4 posies) - Obrigatrio a partir de 03/07/2000
    Valor do documento (10 posies) - Sem vrgula decimal e com ZEROS  esquerda

    A segunda parte do cdigo de barras  um campo livre, que varia de acordo
    com o banco. Esse campo livre ser calculado por esta funo (que voc dever
    alterar de acordo com as informaes fornecidas pelo banco).
   }

   {Segunda parte do cdigo de barras - Campo livre - Varia de acordo com o banco}

   with ATitulo do
   begin
      ACodigoAgencia := Formatar(Cedente.ContaBancaria.CodigoAgencia,3,false,'0');
      ACodigoCedente := Formatar(Cedente.CodigoCedente,8,false,'0');
      ANossoNumero := Formatar(NossoNumero,9,false,'0');
   end;

   Result := ACodigoAgencia + ACodigoCedente + ANossoNumero + '00000';
end;

procedure TgbBanco347.FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string);
begin
   with ATitulo do
   begin
      AAgenciaCodigoCedente := Formatar(Cedente.ContaBancaria.CodigoAgencia,4,false,'0') + '.' + Formatar(Cedente.CodigoCedente,11,false,'0') + '.' + Cedente.DigitoCodigoCedente;
      ANossoNumero := Formatar(NossoNumero,10,false,'0') + '.' + DigitoNossoNumero;
      ACarteira := Formatar(Carteira,2);
      case EspecieDocumento of
         edDuplicataMercantil           : AEspecieDocumento := '01';
         edDuplicataMercantialIndicacao : AEspecieDocumento := '01';
         edDuplicataServico             : AEspecieDocumento := '08';
         edDuplicataServicoIndicacao    : AEspecieDocumento := '08';
         edNotaSeguro                   : AEspecieDocumento := '03';
         edRecibo                       : AEspecieDocumento := '05'
      else
         AEspecieDocumento := '';
      end;
   end;
end;


{$IFNDEF VER120}

function TgbBanco347.GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
begin
   Raise Exception.CreateFmt('Gerao de arquivo remessa no est disponvel para o banco %s - %s',[CodigoBanco,NomeBanco]);
end;

function TgbBanco347.LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
begin
   Raise Exception.CreateFmt('Processamento de arquivo remessa no est disponvel para o banco %s - %s',[CodigoBanco,NomeBanco]);
end;

{$ENDIF}

initialization
RegisterClass(TgbBanco347);

end.
